﻿using System;

namespace ArrayInitialization
{
    class Program
    {
        // Listing 7-3. Dynamiczne tworzenie tablicy.
        static string[] AddNumbers(string[] names)
        {
            string[] numberedNames = new string[names.Length];
            for (int i = 0; i < names.Length; ++i)
            {
                numberedNames[i] = string.Format("{0}: {1}", i, names[i]);
            }
            return numberedNames;
        }

        static void Main(string[] args)
        {
            // Listing 7-4. Sposób działania listy inicjalizatorów.
            string[] eventNames = new string[5];
            eventNames[0] = "Swingowa potańcówka na nabrzeżu";
            eventNames[1] = "Sobotnia noc swingowa";
            eventNames[2] = "Formuła 1 - Grand Prix Niemiec";
            eventNames[3] = "Piknik swingowy";
            eventNames[4] = "Łamańce swingowe w klubie Setka";

            ShowArray(eventNames);

            ShowArray(AddNumbers(eventNames));


            // Listing 7-5. Kiedy inicjalizatory nie działają.
            // Wpisz true by zobaczyć błąd kompilacji.
#if false
            // Tego nie uda się skompilować!
            eventNames =
            {
                "Lekcje shimmy z Deanem Collinsem",
                "Kurs hip-hopu u Łucji dla średniozaawansowanych",
                "Dzikie chwile - tańce społecznościowe w Dzikim Dworze"
            };
#endif

            // Listing 7-6. Połączenie jawnego określenia typu elementów tablicy z listą inicjalizatorów.
            // To się kompiluje!
            eventNames = new string[]
            {
                "Lekcje shimmy z Deanem Collinsem",
                "Kurs hip-hopu u Łucji dla średniozaawansowanych",
                "Dzikie chwile - tańce społecznościowe w Dzikim Dworze"
            };

            ShowArray(eventNames);


            // Listing 7-7. Wpisany inicjalizator tablicy.
            string[] result = AddNumbers(new string[] { "The Jazz Devil", "Jitterbugs" });

            ShowArray(result);
        }

        static void ShowArray(string[] array)
        {
            foreach (string item in array)
            {
                Console.WriteLine(item);
            }
            Console.WriteLine();
        }
    }
}
